function rec_X = parallel_cs_zigzag_perm(X, CR)
% parallel_cs_zigzag_perm.m
%
% Input:
%   X: input 2D sparse or compressible signal.
%   CR: compression ratio.
%
% Output:
%   rec_X: reconstruted signal
% 
% Written: Hao Fang
% Created: Sep. 2012

path(path, './Measurements');
path(path, '../Tools/ZIGZAG_PERM');
path(path, '../Tools/ZIGZAG_SCAN');
path(path, '../ParallelCS');

% measurement matrix
% using same random stream to generate random matrix
% load RandomState
% defaultStream = RandStream.getDefaultStream();
% defaultStream.State = state;

load RandomStates
rand('state', rand_state);
randn('state', randn_state);

[M, N] = size(X);

K = ceil(M * CR);
A = sqrt(1/K) * randn(K, M);


% parallel cs encoding
Y = parallel_cs_encoder(X, A, @perm_zigzag);

% parallel cs decoding
rec_X = parallel_cs_decoder(Y, A, @invperm_zigzag);

end
